<?php

  class nixmoney 
  {
    var $code, $title, $description, $enabled;

    function nixmoney() 
	{
		global $order;

		$this->code = 'nixmoney';
		$this->title = MODULE_PAYMENT_NIXMONEY_TEXT_TITLE;
		$this->description = MODULE_PAYMENT_NIXMONEY_TEXT_DESCRIPTION;
		$this->icon = 'logo_nixmoney.png';
		$this->icon_small = 'nixmoney.png';
		$this->sort_order = MODULE_PAYMENT_NIXMONEY_SORT_ORDER;
		$this->enabled = ((MODULE_PAYMENT_NIXMONEY_STATUS == 'True') ? true : false);

		if ((int)MODULE_PAYMENT_NIXMONEY_ORDER_STATUS_ID > 0) 
		{
			$this->order_status = MODULE_PAYMENT_NIXMONEY_ORDER_STATUS_ID;
		}

		$this->form_action_url = MODULE_PAYMENT_NIXMONEY_MERCHANT_URL;
    }

    function javascript_validation() 
	{
		return false;
    }

    function selection() 
	{
		return array('id' => $this->code, 'module' => $this->title);
    }

    function pre_confirmation_check() 
	{
		return false;
    }

    function confirmation() 
	{
		return false;
    }

    function process_button() 
	{
		global $order, $currencies, $currency, $osPrice;

		$m_shop = MODULE_PAYMENT_NIXMONEY_MERCHANT_ID;

		$order_id_query = os_db_query("SELECT MAX(orders_id) AS max FROM " . TABLE_ORDERS);
		$order_id = os_db_fetch_array($order_id_query);
		$order_id = $order_id['max'];
		$m_orderid = $order_id + 1;

		$m_amount = number_format($order->info['total'], 2, '.', '');

		$m_curr = $order->info['currency'];

		$m_desc = MODULE_PAYMENT_NIXMONEY_DESCRIPTION;

		$m_key = MODULE_PAYMENT_NIXMONEY_SECRET_KEY;

		$status_url = 'http://'. $_SERVER['HTTP_HOST'].'/modules/payment/nixmoney/status.php';
		$payment_url = 'http://'. $_SERVER['HTTP_HOST'].'/checkout_process.php?result=success';
		$nopayment_url = 'http://'. $_SERVER['HTTP_HOST'].'/checkout_process.php?result=fail';
		
		$process_button_string =os_draw_hidden_field('PAYEE_ACCOUNT', $m_shop) .
								os_draw_hidden_field('PAYEE_NAME', $m_orderid) .
								os_draw_hidden_field('PAYMENT_ID', $m_orderid) .
								os_draw_hidden_field('PAYMENT_AMOUNT', $order->info['total']) .
								os_draw_hidden_field('PAYMENT_UNITS', $m_curr) .
								os_draw_hidden_field('SUGGESTED_MEMO', $m_desc) .
								os_draw_hidden_field('STATUS_URL', $status_url) .
								os_draw_hidden_field('PAYMENT_URL', $payment_url) .
								os_draw_hidden_field('NOPAYMENT_URL', $nopayment_url);
								
		return $process_button_string;
    }

    function before_process() 
	{
		return false;
    }

    function after_process()
	{
		return false;
    }

    function output_error()
	{
		return false;
    }

    function check() 
	{
		if (!isset($this->_check)) 
		{
			$check_query = os_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_NIXMONEY_STATUS'");
			$this->_check = os_db_num_rows($check_query);
		}
		return $this->_check;
    }

    function install() 
	{
		os_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_NIXMONEY_STATUS', 'True', '6', '1', 'os_cfg_select_option(array(\'True\', \'False\'), ', now())");
		os_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NIXMONEY_MERCHANT_URL', 'https://www.nixmoney.com/merchant.jsp', '6', '8', now())");
		os_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NIXMONEY_MERCHANT_ID', '', '6', '0', now())");
		os_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NIXMONEY_SECRET_KEY', '', '6', '1', now())");
		os_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NIXMONEY_DESCRIPTION', '', '6', '2', now())");
		os_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NIXMONEY_IPFILTER', '', '6', '4', now())");
		os_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NIXMONEY_EMAILERR', '', '6', '5', now())");
		os_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NIXMONEY_LOGFILE', '', '6', '6', now())");
		os_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NIXMONEY_SORT_ORDER', '1', '6', '7', now())");
		os_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_NIXMONEY_ORDER_STATUS_ID', '0', '6', '0', 'os_cfg_pull_down_order_statuses(', 'os_get_order_status_name', now())");
    }

    function remove()
	{
		os_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys()
	{
		return array(
			'MODULE_PAYMENT_NIXMONEY_STATUS',
			'MODULE_PAYMENT_NIXMONEY_MERCHANT_URL',
			'MODULE_PAYMENT_NIXMONEY_MERCHANT_ID',
			'MODULE_PAYMENT_NIXMONEY_SECRET_KEY',
			'MODULE_PAYMENT_NIXMONEY_DESCRIPTION', 
			'MODULE_PAYMENT_NIXMONEY_IPFILTER', 
			'MODULE_PAYMENT_NIXMONEY_EMAILERR', 
			'MODULE_PAYMENT_NIXMONEY_LOGFILE', 
			'MODULE_PAYMENT_NIXMONEY_SORT_ORDER', 
			'MODULE_PAYMENT_NIXMONEY_ORDER_STATUS_ID'
		);
    }
  }
?>